@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Result of AmlCompute Nodes
 * @property nextLink The continuation token.
 * @property nodes The collection of returned AmlCompute nodes details.
 */
public data class ListComputeNodesResult(
    public val nextLink: String,
    public val nodes: List<AmlComputeNodeInformationResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ListComputeNodesResult): ListComputeNodesResult = ListComputeNodesResult(
            nextLink = javaType.nextLink(),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AmlComputeNodeInformationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
