@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appInsightsInstrumentationKey
 * @property containerRegistryCredentials
 * @property notebookAccessKeys
 * @property userStorageKey
 * @property userStorageResourceId
 */
public data class ListWorkspaceKeysResult(
    public val appInsightsInstrumentationKey: String,
    public val containerRegistryCredentials: RegistryListCredentialsResultResponse,
    public val notebookAccessKeys: ListNotebookKeysResultResponse,
    public val userStorageKey: String,
    public val userStorageResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ListWorkspaceKeysResult): ListWorkspaceKeysResult = ListWorkspaceKeysResult(
            appInsightsInstrumentationKey = javaType.appInsightsInstrumentationKey(),
            containerRegistryCredentials = javaType.containerRegistryCredentials().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RegistryListCredentialsResultResponse.Companion.toKotlin(args0)
            }),
            notebookAccessKeys = javaType.notebookAccessKeys().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListNotebookKeysResultResponse.Companion.toKotlin(args0)
            }),
            userStorageKey = javaType.userStorageKey(),
            userStorageResourceId = javaType.userStorageResourceId(),
        )
    }
}
