@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Labeling MLAssist configuration definition when MLAssist is enabled
 * @property inferencingComputeBinding [Required] AML compute binding used in inferencing.
 * @property mlAssist
 * Expected value is 'Enabled'.
 * @property trainingComputeBinding [Required] AML compute binding used in training.
 */
public data class MLAssistConfigurationEnabledResponse(
    public val inferencingComputeBinding: String,
    public val mlAssist: String,
    public val trainingComputeBinding: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.MLAssistConfigurationEnabledResponse): MLAssistConfigurationEnabledResponse = MLAssistConfigurationEnabledResponse(
            inferencingComputeBinding = javaType.inferencingComputeBinding(),
            mlAssist = javaType.mlAssist(),
            trainingComputeBinding = javaType.trainingComputeBinding(),
        )
    }
}
