@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed identity configuration.
 * @property clientId Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
 * @property identityType Enum to determine identity framework.
 * Expected value is 'Managed'.
 * @property objectId Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
 * @property resourceId Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
 */
public data class ManagedIdentityResponse(
    public val clientId: String? = null,
    public val identityType: String,
    public val objectId: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ManagedIdentityResponse): ManagedIdentityResponse = ManagedIdentityResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            identityType = javaType.identityType(),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
