@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties specific to a ManagedOnlineDeployment.
 * @property appInsightsEnabled If true, enables Application Insights logging.
 * @property codeConfiguration Code configuration for the endpoint deployment.
 * @property description Description of the endpoint deployment.
 * @property egressPublicNetworkAccess If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
 * @property endpointComputeType Enum to determine endpoint compute type.
 * Expected value is 'Managed'.
 * @property environmentId ARM resource ID or AssetId of the environment specification for the endpoint deployment.
 * @property environmentVariables Environment variables configuration for the deployment.
 * @property instanceType Compute instance type.
 * @property livenessProbe Liveness probe monitors the health of the container regularly.
 * @property model The URI path to the model.
 * @property modelMountPath The path to mount the model in custom container.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property provisioningState Provisioning state for the endpoint deployment.
 * @property readinessProbe Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
 * @property requestSettings Request settings for the deployment.
 * @property scaleSettings Scale settings for the deployment.
 * If it is null or not provided,
 * it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
 * and to DefaultScaleSettings for ManagedOnlineDeployment.
 */
public data class ManagedOnlineDeploymentResponse(
    public val appInsightsEnabled: Boolean? = null,
    public val codeConfiguration: CodeConfigurationResponse? = null,
    public val description: String? = null,
    public val egressPublicNetworkAccess: String? = null,
    public val endpointComputeType: String,
    public val environmentId: String? = null,
    public val environmentVariables: Map<String, String>? = null,
    public val instanceType: String? = null,
    public val livenessProbe: ProbeSettingsResponse? = null,
    public val model: String? = null,
    public val modelMountPath: String? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val readinessProbe: ProbeSettingsResponse? = null,
    public val requestSettings: OnlineRequestSettingsResponse? = null,
    public val scaleSettings: Either<DefaultScaleSettingsResponse, TargetUtilizationScaleSettingsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ManagedOnlineDeploymentResponse): ManagedOnlineDeploymentResponse = ManagedOnlineDeploymentResponse(
            appInsightsEnabled = javaType.appInsightsEnabled().map({ args0 -> args0 }).orElse(null),
            codeConfiguration = javaType.codeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            egressPublicNetworkAccess = javaType.egressPublicNetworkAccess().map({ args0 ->
                args0
            }).orElse(null),
            endpointComputeType = javaType.endpointComputeType(),
            environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            livenessProbe = javaType.livenessProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ProbeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            model = javaType.model().map({ args0 -> args0 }).orElse(null),
            modelMountPath = javaType.modelMountPath().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            readinessProbe = javaType.readinessProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ProbeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requestSettings = javaType.requestSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.OnlineRequestSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scaleSettings = javaType.scaleSettings().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DefaultScaleSettingsResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.TargetUtilizationScaleSettingsResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
        )
    }
}
