@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property marketplacePlan Marketplace Plan associated with the Marketplace Subscription.
 * @property marketplaceSubscriptionStatus Current status of the Marketplace Subscription.
 * @property modelId [Required] Target Marketplace Model ID to create a Marketplace Subscription for.
 * @property provisioningState Provisioning State of the Marketplace Subscription.
 */
public data class MarketplaceSubscriptionResponse(
    public val marketplacePlan: MarketplacePlanResponse,
    public val marketplaceSubscriptionStatus: String,
    public val modelId: String,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.MarketplaceSubscriptionResponse): MarketplaceSubscriptionResponse = MarketplaceSubscriptionResponse(
            marketplacePlan = javaType.marketplacePlan().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MarketplacePlanResponse.Companion.toKotlin(args0)
            }),
            marketplaceSubscriptionStatus = javaType.marketplaceSubscriptionStatus(),
            modelId = javaType.modelId(),
            provisioningState = javaType.provisioningState(),
        )
    }
}
