@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property notification Specifies the notification details
 * @property resource Specifies the compute resource settings
 * @property schedule Specifies the schedule details
 * @property sparkConfiguration Specifies the spark compute settings
 * @property storeType Specifies the stores to which materialization should happen
 */
public data class MaterializationSettingsResponse(
    public val notification: NotificationSettingResponse? = null,
    public val resource: MaterializationComputeResourceResponse? = null,
    public val schedule: RecurrenceTriggerResponse? = null,
    public val sparkConfiguration: Map<String, String>? = null,
    public val storeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.MaterializationSettingsResponse): MaterializationSettingsResponse = MaterializationSettingsResponse(
            notification = javaType.notification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NotificationSettingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resource = javaType.resource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MaterializationComputeResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RecurrenceTriggerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sparkConfiguration = javaType.sparkConfiguration().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            storeType = javaType.storeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
