@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cognitive Services account ModelDeprecationInfo.
 * @property fineTune The datetime of deprecation of the fineTune Model.
 * @property inference The datetime of deprecation of the inference Model.
 */
public data class ModelDeprecationInfoResponse(
    public val fineTune: String? = null,
    public val inference: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ModelDeprecationInfoResponse): ModelDeprecationInfoResponse = ModelDeprecationInfoResponse(
            fineTune = javaType.fineTune().map({ args0 -> args0 }).orElse(null),
            inference = javaType.inference().map({ args0 -> args0 }).orElse(null),
        )
    }
}
