@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes an available Cognitive Services Model SKU.
 * @property capacity The capacity configuration.
 * @property connectionIds The list of connection ids.
 * @property deprecationDate The datetime of deprecation of the model SKU.
 * @property name The name of the model SKU.
 * @property rateLimits The list of rateLimit.
 * @property usageName The usage name of the model SKU.
 */
public data class ModelSkuResponse(
    public val capacity: CapacityConfigResponse? = null,
    public val connectionIds: List<String>? = null,
    public val deprecationDate: String? = null,
    public val name: String? = null,
    public val rateLimits: List<CallRateLimitResponse>? = null,
    public val usageName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ModelSkuResponse): ModelSkuResponse = ModelSkuResponse(
            capacity = javaType.capacity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CapacityConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionIds = javaType.connectionIds().map({ args0 -> args0 }),
            deprecationDate = javaType.deprecationDate().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            rateLimits = javaType.rateLimits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CallRateLimitResponse.Companion.toKotlin(args0)
                })
            }),
            usageName = javaType.usageName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
