@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Model asset version details.
 * @property description The asset description text.
 * @property flavors Mapping of model flavors to their properties.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property jobName Name of the training job which produced this model
 * @property modelType The storage format for this entity. Used for NCD.
 * @property modelUri The URI path to the model contents.
 * @property properties The asset property dictionary.
 * @property provisioningState Provisioning state for the model version.
 * @property stage Stage in the model lifecycle assigned to this model
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class ModelVersionResponse(
    public val description: String? = null,
    public val flavors: Map<String, FlavorDataResponse>? = null,
    public val isAnonymous: Boolean? = null,
    public val isArchived: Boolean? = null,
    public val jobName: String? = null,
    public val modelType: String? = null,
    public val modelUri: String? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val stage: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ModelVersionResponse): ModelVersionResponse = ModelVersionResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            flavors = javaType.flavors().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FlavorDataResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            isAnonymous = javaType.isAnonymous().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            jobName = javaType.jobName().map({ args0 -> args0 }).orElse(null),
            modelType = javaType.modelType().map({ args0 -> args0 }).orElse(null),
            modelUri = javaType.modelUri().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            stage = javaType.stage().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
