@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Counts of various compute node states on the amlCompute.
 * @property idleNodeCount Number of compute nodes in idle state.
 * @property leavingNodeCount Number of compute nodes which are leaving the amlCompute.
 * @property preemptedNodeCount Number of compute nodes which are in preempted state.
 * @property preparingNodeCount Number of compute nodes which are being prepared.
 * @property runningNodeCount Number of compute nodes which are running jobs.
 * @property unusableNodeCount Number of compute nodes which are in unusable state.
 */
public data class NodeStateCountsResponse(
    public val idleNodeCount: Int,
    public val leavingNodeCount: Int,
    public val preemptedNodeCount: Int,
    public val preparingNodeCount: Int,
    public val runningNodeCount: Int,
    public val unusableNodeCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.NodeStateCountsResponse): NodeStateCountsResponse = NodeStateCountsResponse(
            idleNodeCount = javaType.idleNodeCount(),
            leavingNodeCount = javaType.leavingNodeCount(),
            preemptedNodeCount = javaType.preemptedNodeCount(),
            preparingNodeCount = javaType.preparingNodeCount(),
            runningNodeCount = javaType.runningNodeCount(),
            unusableNodeCount = javaType.unusableNodeCount(),
        )
    }
}
