@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Configuration for notification.
 * @property emailOn Send email notification to user on specified notification type
 * @property emails This is the email recipient list which has a limitation of 499 characters in total concat with comma separator
 * @property webhooks Send webhook callback to a service. Key is a user-provided name for the webhook.
 */
public data class NotificationSettingResponse(
    public val emailOn: List<String>? = null,
    public val emails: List<String>? = null,
    public val webhooks: Map<String, AzureDevOpsWebhookResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.NotificationSettingResponse): NotificationSettingResponse = NotificationSettingResponse(
            emailOn = javaType.emailOn().map({ args0 -> args0 }),
            emails = javaType.emails().map({ args0 -> args0 }),
            webhooks = javaType.webhooks().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AzureDevOpsWebhookResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
