@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Online endpoint configuration
 * @property authMode [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
 * @property compute ARM resource ID of the compute if it exists.
 * optional
 * @property description Description of the inference endpoint.
 * @property mirrorTraffic Percentage of traffic to be mirrored to each deployment without using returned scoring. Traffic values need to sum to utmost 50.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property provisioningState Provisioning state for the endpoint.
 * @property publicNetworkAccess Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
 * @property scoringUri Endpoint URI.
 * @property swaggerUri Endpoint Swagger URI.
 * @property traffic Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
 */
public data class OnlineEndpointResponse(
    public val authMode: String,
    public val compute: String? = null,
    public val description: String? = null,
    public val mirrorTraffic: Map<String, Int>? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val scoringUri: String,
    public val swaggerUri: String,
    public val traffic: Map<String, Int>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.OnlineEndpointResponse): OnlineEndpointResponse = OnlineEndpointResponse(
            authMode = javaType.authMode(),
            compute = javaType.compute().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            mirrorTraffic = javaType.mirrorTraffic().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            scoringUri = javaType.scoringUri(),
            swaggerUri = javaType.swaggerUri(),
            traffic = javaType.traffic().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
