@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Online deployment scoring requests configuration.
 * @property maxConcurrentRequestsPerInstance The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
 * @property maxQueueWait The maximum amount of time a request will stay in the queue in ISO 8601 format.
 * Defaults to 500ms.
 * @property requestTimeout The scoring timeout in ISO 8601 format.
 * Defaults to 5000ms.
 */
public data class OnlineRequestSettingsResponse(
    public val maxConcurrentRequestsPerInstance: Int? = null,
    public val maxQueueWait: String? = null,
    public val requestTimeout: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.OnlineRequestSettingsResponse): OnlineRequestSettingsResponse = OnlineRequestSettingsResponse(
            maxConcurrentRequestsPerInstance = javaType.maxConcurrentRequestsPerInstance().map({ args0 ->
                args0
            }).orElse(null),
            maxQueueWait = javaType.maxQueueWait().map({ args0 -> args0 }).orElse(null),
            requestTimeout = javaType.requestTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
