@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reference to an asset via its path in a job output.
 * @property jobId ARM resource ID of the job.
 * @property path The path of the file/directory in the job output.
 * @property referenceType Enum to determine which reference method to use for an asset.
 * Expected value is 'OutputPath'.
 */
public data class OutputPathAssetReferenceResponse(
    public val jobId: String? = null,
    public val path: String? = null,
    public val referenceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.OutputPathAssetReferenceResponse): OutputPathAssetReferenceResponse = OutputPathAssetReferenceResponse(
            jobId = javaType.jobId().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            referenceType = javaType.referenceType(),
        )
    }
}
