@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Pipeline Job definition: defines generic to MFE attributes.
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property inputs Inputs for the pipeline job.
 * @property isArchived Is the asset archived?
 * @property jobType Enum to determine the type of job.
 * Expected value is 'Pipeline'.
 * @property jobs Jobs construct the Pipeline Job.
 * @property outputs Outputs for the pipeline job
 * @property properties The asset property dictionary.
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property settings Pipeline settings, for things like ContinueRunOnStepFailure etc.
 * @property sourceJobId ARM resource ID of source job.
 * @property status Status of the job.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class PipelineJobResponse(
    public val componentId: String? = null,
    public val computeId: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val experimentName: String? = null,
    public val identity: Any? = null,
    public val inputs: Map<String, Any>? = null,
    public val isArchived: Boolean? = null,
    public val jobType: String,
    public val jobs: Map<String, Any>? = null,
    public val outputs: Map<String, Any>? = null,
    public val properties: Map<String, String>? = null,
    public val services: Map<String, JobServiceResponse>? = null,
    public val settings: Any? = null,
    public val sourceJobId: String? = null,
    public val status: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.PipelineJobResponse): PipelineJobResponse = PipelineJobResponse(
            componentId = javaType.componentId().map({ args0 -> args0 }).orElse(null),
            computeId = javaType.computeId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            experimentName = javaType.experimentName().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            inputs = javaType.inputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            jobType = javaType.jobType(),
            jobs = javaType.jobs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            outputs = javaType.outputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            services = javaType.services().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobServiceResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            settings = javaType.settings().map({ args0 -> args0 }).orElse(null),
            sourceJobId = javaType.sourceJobId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
