@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Deployment container liveness/readiness probe configuration.
 * @property failureThreshold The number of failures to allow before returning an unhealthy status.
 * @property initialDelay The delay before the first probe in ISO 8601 format.
 * @property period The length of time between probes in ISO 8601 format.
 * @property successThreshold The number of successful probes before returning a healthy status.
 * @property timeout The probe timeout in ISO 8601 format.
 */
public data class ProbeSettingsResponse(
    public val failureThreshold: Int? = null,
    public val initialDelay: String? = null,
    public val period: String? = null,
    public val successThreshold: Int? = null,
    public val timeout: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ProbeSettingsResponse): ProbeSettingsResponse = ProbeSettingsResponse(
            failureThreshold = javaType.failureThreshold().map({ args0 -> args0 }).orElse(null),
            initialDelay = javaType.initialDelay().map({ args0 -> args0 }).orElse(null),
            period = javaType.period().map({ args0 -> args0 }).orElse(null),
            successThreshold = javaType.successThreshold().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
