@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Progress metrics definition
 * @property completedDatapointCount The completed datapoint count.
 * @property incrementalDataLastRefreshDateTime The time of last successful incremental data refresh in UTC.
 * @property skippedDatapointCount The skipped datapoint count.
 * @property totalDatapointCount The total datapoint count.
 */
public data class ProgressMetricsResponse(
    public val completedDatapointCount: Double,
    public val incrementalDataLastRefreshDateTime: String,
    public val skippedDatapointCount: Double,
    public val totalDatapointCount: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ProgressMetricsResponse): ProgressMetricsResponse = ProgressMetricsResponse(
            completedDatapointCount = javaType.completedDatapointCount(),
            incrementalDataLastRefreshDateTime = javaType.incrementalDataLastRefreshDateTime(),
            skippedDatapointCount = javaType.skippedDatapointCount(),
            totalDatapointCount = javaType.totalDatapointCount(),
        )
    }
}
