@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure OpenAI Content Filters properties.
 * @property basePolicyName Name of the base Content Filters.
 * @property completionBlocklists
 * @property contentFilters
 * @property mode Content Filters mode.
 * @property promptBlocklists
 * @property type Content Filters policy type.
 */
public data class RaiPolicyPropertiesResponse(
    public val basePolicyName: String? = null,
    public val completionBlocklists: List<RaiBlocklistConfigResponse>? = null,
    public val contentFilters: List<RaiPolicyContentFilterResponse>? = null,
    public val mode: String? = null,
    public val promptBlocklists: List<RaiBlocklistConfigResponse>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RaiPolicyPropertiesResponse): RaiPolicyPropertiesResponse = RaiPolicyPropertiesResponse(
            basePolicyName = javaType.basePolicyName().map({ args0 -> args0 }).orElse(null),
            completionBlocklists = javaType.completionBlocklists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiBlocklistConfigResponse.Companion.toKotlin(args0)
                })
            }),
            contentFilters = javaType.contentFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiPolicyContentFilterResponse.Companion.toKotlin(args0)
                })
            }),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            promptBlocklists = javaType.promptBlocklists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RaiBlocklistConfigResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
