@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hours [Required] List of hours for the schedule.
 * @property minutes [Required] List of minutes for the schedule.
 * @property monthDays List of month days for the schedule
 * @property weekDays List of days for the schedule.
 */
public data class RecurrenceScheduleResponse(
    public val hours: List<Int>,
    public val minutes: List<Int>,
    public val monthDays: List<Int>? = null,
    public val weekDays: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RecurrenceScheduleResponse): RecurrenceScheduleResponse = RecurrenceScheduleResponse(
            hours = javaType.hours().map({ args0 -> args0 }),
            minutes = javaType.minutes().map({ args0 -> args0 }),
            monthDays = javaType.monthDays().map({ args0 -> args0 }),
            weekDays = javaType.weekDays().map({ args0 -> args0 }),
        )
    }
}
