@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property location
 * @property passwords
 * @property username
 */
public data class RegistryListCredentialsResultResponse(
    public val location: String,
    public val passwords: List<PasswordResponse>? = null,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RegistryListCredentialsResultResponse): RegistryListCredentialsResultResponse = RegistryListCredentialsResultResponse(
            location = javaType.location(),
            passwords = javaType.passwords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.PasswordResponse.Companion.toKotlin(args0)
                })
            }),
            username = javaType.username(),
        )
    }
}
