@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details for each region the registry is in
 * @property acrDetails List of ACR accounts
 * @property location The location where the registry exists
 * @property storageAccountDetails List of storage accounts
 */
public data class RegistryRegionArmDetailsResponse(
    public val acrDetails: List<AcrDetailsResponse>? = null,
    public val location: String? = null,
    public val storageAccountDetails: List<StorageAccountDetailsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RegistryRegionArmDetailsResponse): RegistryRegionArmDetailsResponse = RegistryRegionArmDetailsResponse(
            acrDetails = javaType.acrDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AcrDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            storageAccountDetails = javaType.storageAccountDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.StorageAccountDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
