@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of the Registry
 * @property discoveryUrl Discovery URL for the Registry
 * @property intellectualPropertyPublisher IntellectualPropertyPublisher for the registry
 * @property managedResourceGroup ResourceId of the managed RG if the registry has system created resources
 * @property mlFlowRegistryUri MLFlow Registry URI for the Registry
 * @property privateEndpointConnections Private endpoint connections info used for pending connections in private link portal
 * @property publicNetworkAccess Is the Registry accessible from the internet?
 * Possible values: "Enabled" or "Disabled"
 * @property regionDetails Details of each region the registry is in
 */
public data class RegistryResponse(
    public val discoveryUrl: String? = null,
    public val intellectualPropertyPublisher: String? = null,
    public val managedResourceGroup: ArmResourceIdResponse? = null,
    public val mlFlowRegistryUri: String? = null,
    public val privateEndpointConnections: List<RegistryPrivateEndpointConnectionResponse>? = null,
    public val publicNetworkAccess: String? = null,
    public val regionDetails: List<RegistryRegionArmDetailsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RegistryResponse): RegistryResponse = RegistryResponse(
            discoveryUrl = javaType.discoveryUrl().map({ args0 -> args0 }).orElse(null),
            intellectualPropertyPublisher = javaType.intellectualPropertyPublisher().map({ args0 ->
                args0
            }).orElse(null),
            managedResourceGroup = javaType.managedResourceGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ArmResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mlFlowRegistryUri = javaType.mlFlowRegistryUri().map({ args0 -> args0 }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RegistryPrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            regionDetails = javaType.regionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RegistryRegionArmDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
