@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Regression task in AutoML Table vertical.
 * @property cvSplitColumnNames Columns to use for CVSplit data.
 * @property featurizationSettings Featurization inputs needed for AutoML job.
 * @property limitSettings Execution constraints for AutoMLJob.
 * @property logVerbosity Log verbosity for the job.
 * @property nCrossValidations Number of cross validation folds to be applied on training dataset
 * when validation dataset is not provided.
 * @property primaryMetric Primary metric for regression task.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'Regression'.
 * @property testData Test data input.
 * @property testDataSize The fraction of test dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property trainingData [Required] Training data input.
 * @property trainingSettings Inputs for training phase for an AutoML Job.
 * @property validationData Validation data inputs.
 * @property validationDataSize The fraction of training dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property weightColumnName The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
 */
public data class RegressionResponse(
    public val cvSplitColumnNames: List<String>? = null,
    public val featurizationSettings: TableVerticalFeaturizationSettingsResponse? = null,
    public val limitSettings: TableVerticalLimitSettingsResponse? = null,
    public val logVerbosity: String? = null,
    public val nCrossValidations: Either<AutoNCrossValidationsResponse, CustomNCrossValidationsResponse>? = null,
    public val primaryMetric: String? = null,
    public val targetColumnName: String? = null,
    public val taskType: String,
    public val testData: MLTableJobInputResponse? = null,
    public val testDataSize: Double? = null,
    public val trainingData: MLTableJobInputResponse,
    public val trainingSettings: RegressionTrainingSettingsResponse? = null,
    public val validationData: MLTableJobInputResponse? = null,
    public val validationDataSize: Double? = null,
    public val weightColumnName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RegressionResponse): RegressionResponse = RegressionResponse(
            cvSplitColumnNames = javaType.cvSplitColumnNames().map({ args0 -> args0 }),
            featurizationSettings = javaType.featurizationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.TableVerticalFeaturizationSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            limitSettings = javaType.limitSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.TableVerticalLimitSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logVerbosity = javaType.logVerbosity().map({ args0 -> args0 }).orElse(null),
            nCrossValidations = javaType.nCrossValidations().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoNCrossValidationsResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CustomNCrossValidationsResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            primaryMetric = javaType.primaryMetric().map({ args0 -> args0 }).orElse(null),
            targetColumnName = javaType.targetColumnName().map({ args0 -> args0 }).orElse(null),
            taskType = javaType.taskType(),
            testData = javaType.testData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLTableJobInputResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            testDataSize = javaType.testDataSize().map({ args0 -> args0 }).orElse(null),
            trainingData = javaType.trainingData().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLTableJobInputResponse.Companion.toKotlin(args0)
            }),
            trainingSettings = javaType.trainingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RegressionTrainingSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            validationData = javaType.validationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLTableJobInputResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            validationDataSize = javaType.validationDataSize().map({ args0 -> args0 }).orElse(null),
            weightColumnName = javaType.weightColumnName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
