@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * scale settings for AML Compute
 * @property maxNodeCount Max number of nodes to use
 * @property minNodeCount Min number of nodes to use
 * @property nodeIdleTimeBeforeScaleDown Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
 */
public data class ScaleSettingsResponse(
    public val maxNodeCount: Int,
    public val minNodeCount: Int? = null,
    public val nodeIdleTimeBeforeScaleDown: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ScaleSettingsResponse): ScaleSettingsResponse = ScaleSettingsResponse(
            maxNodeCount = javaType.maxNodeCount(),
            minNodeCount = javaType.minNodeCount().map({ args0 -> args0 }).orElse(null),
            nodeIdleTimeBeforeScaleDown = javaType.nodeIdleTimeBeforeScaleDown().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
