@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Script reference
 * @property scriptArguments Optional command line arguments passed to the script to run.
 * @property scriptData The location of scripts in the mounted volume.
 * @property scriptSource The storage source of the script: workspace.
 * @property timeout Optional time period passed to timeout command.
 */
public data class ScriptReferenceResponse(
    public val scriptArguments: String? = null,
    public val scriptData: String? = null,
    public val scriptSource: String? = null,
    public val timeout: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ScriptReferenceResponse): ScriptReferenceResponse = ScriptReferenceResponse(
            scriptArguments = javaType.scriptArguments().map({ args0 -> args0 }).orElse(null),
            scriptData = javaType.scriptData().map({ args0 -> args0 }).orElse(null),
            scriptSource = javaType.scriptSource().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
