@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Secret Configuration definition.
 * @property uri Secret Uri.
 * Sample Uri : https://myvault.vault.azure.net/secrets/mysecretname/secretversion
 * @property workspaceSecretName Name of secret in workspace key vault.
 */
public data class SecretConfigurationResponse(
    public val uri: String? = null,
    public val workspaceSecretName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SecretConfigurationResponse): SecretConfigurationResponse = SecretConfigurationResponse(
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
            workspaceSecretName = javaType.workspaceSecretName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
