@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property headers Specifies any required headers to target this serverless endpoint.
 * @property uri [Required] The inference uri to target when making requests against the Serverless Endpoint.
 */
public data class ServerlessInferenceEndpointResponse(
    public val headers: Map<String, String>,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ServerlessInferenceEndpointResponse): ServerlessInferenceEndpointResponse = ServerlessInferenceEndpointResponse(
            headers = javaType.headers().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            uri = javaType.uri(),
        )
    }
}
