@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Service Principal datastore credentials configuration.
 * @property authorityUrl Authority URL used for authentication.
 * @property clientId [Required] Service principal client ID.
 * @property credentialsType Enum to determine the datastore credentials type.
 * Expected value is 'ServicePrincipal'.
 * @property resourceUrl Resource the service principal has access to.
 * @property tenantId [Required] ID of the tenant to which the service principal belongs.
 */
public data class ServicePrincipalDatastoreCredentialsResponse(
    public val authorityUrl: String? = null,
    public val clientId: String,
    public val credentialsType: String,
    public val resourceUrl: String? = null,
    public val tenantId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ServicePrincipalDatastoreCredentialsResponse): ServicePrincipalDatastoreCredentialsResponse = ServicePrincipalDatastoreCredentialsResponse(
            authorityUrl = javaType.authorityUrl().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId(),
            credentialsType = javaType.credentialsType(),
            resourceUrl = javaType.resourceUrl().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId(),
        )
    }
}
