@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace.
 * @property portRanges
 * @property protocol
 * @property serviceTag
 */
public data class ServiceTagDestinationResponse(
    public val portRanges: String? = null,
    public val protocol: String? = null,
    public val serviceTag: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ServiceTagDestinationResponse): ServiceTagDestinationResponse = ServiceTagDestinationResponse(
            portRanges = javaType.portRanges().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            serviceTag = javaType.serviceTag().map({ args0 -> args0 }).orElse(null),
        )
    }
}
