@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Service Tag Outbound Rule for the managed network of a machine learning workspace.
 * @property category Category of a managed network Outbound Rule of a machine learning workspace.
 * @property destination Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace.
 * @property status Status of a managed network Outbound Rule of a machine learning workspace.
 * @property type Type of a managed network Outbound Rule of a machine learning workspace.
 * Expected value is 'ServiceTag'.
 */
public data class ServiceTagOutboundRuleResponse(
    public val category: String? = null,
    public val destination: ServiceTagDestinationResponse? = null,
    public val status: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ServiceTagOutboundRuleResponse): ServiceTagOutboundRuleResponse = ServiceTagOutboundRuleResponse(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            destination = javaType.destination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ServiceTagDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
