@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupId The private link resource group id.
 * @property name Unique name of the private link.
 * @property privateLinkResourceId The resource id that private link links to.
 * @property requestMessage Request message.
 * @property status Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public data class SharedPrivateLinkResourceResponse(
    public val groupId: String? = null,
    public val name: String? = null,
    public val privateLinkResourceId: String? = null,
    public val requestMessage: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SharedPrivateLinkResourceResponse): SharedPrivateLinkResourceResponse = SharedPrivateLinkResourceResponse(
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateLinkResourceId = javaType.privateLinkResourceId().map({ args0 -> args0 }).orElse(null),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
