@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The ssl configuration for scoring
 * @property cert Cert data
 * @property cname CNAME of the cert
 * @property key Key data
 * @property leafDomainLabel Leaf domain label of public endpoint
 * @property overwriteExistingDomain Indicates whether to overwrite existing domain label.
 * @property status Enable or disable ssl for scoring
 */
public data class SslConfigurationResponse(
    public val cert: String? = null,
    public val cname: String? = null,
    public val key: String? = null,
    public val leafDomainLabel: String? = null,
    public val overwriteExistingDomain: Boolean? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SslConfigurationResponse): SslConfigurationResponse = SslConfigurationResponse(
            cert = javaType.cert().map({ args0 -> args0 }).orElse(null),
            cname = javaType.cname().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            leafDomainLabel = javaType.leafDomainLabel().map({ args0 -> args0 }).orElse(null),
            overwriteExistingDomain = javaType.overwriteExistingDomain().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
