@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Active message associated with project
 * @property code Service-defined message code.
 * @property createdDateTime Time in UTC at which the message was created.
 * @property level Severity level of message.
 * @property message A human-readable representation of the message code.
 */
public data class StatusMessageResponse(
    public val code: String,
    public val createdDateTime: String,
    public val level: String,
    public val message: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.StatusMessageResponse): StatusMessageResponse = StatusMessageResponse(
            code = javaType.code(),
            createdDateTime = javaType.createdDateTime(),
            level = javaType.level(),
            message = javaType.message(),
        )
    }
}
