@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Suppress

/**
 * Details of storage account to be used for the Registry
 * @property systemCreatedStorageAccount Details of system created storage account to be used for the registry
 * @property userCreatedStorageAccount Details of user created storage account to be used for the registry
 */
public data class StorageAccountDetailsResponse(
    public val systemCreatedStorageAccount: SystemCreatedStorageAccountResponse? = null,
    public val userCreatedStorageAccount: UserCreatedStorageAccountResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.StorageAccountDetailsResponse): StorageAccountDetailsResponse = StorageAccountDetailsResponse(
            systemCreatedStorageAccount = javaType.systemCreatedStorageAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemCreatedStorageAccountResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userCreatedStorageAccount = javaType.userCreatedStorageAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.UserCreatedStorageAccountResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
