@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Sweep Job limit class.
 * @property jobLimitsType
 * Expected value is 'Sweep'.
 * @property maxConcurrentTrials Sweep Job max concurrent trials.
 * @property maxTotalTrials Sweep Job max total trials.
 * @property timeout The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
 * @property trialTimeout Sweep Job Trial timeout value.
 */
public data class SweepJobLimitsResponse(
    public val jobLimitsType: String,
    public val maxConcurrentTrials: Int? = null,
    public val maxTotalTrials: Int? = null,
    public val timeout: String? = null,
    public val trialTimeout: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SweepJobLimitsResponse): SweepJobLimitsResponse = SweepJobLimitsResponse(
            jobLimitsType = javaType.jobLimitsType(),
            maxConcurrentTrials = javaType.maxConcurrentTrials().map({ args0 -> args0 }).orElse(null),
            maxTotalTrials = javaType.maxTotalTrials().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            trialTimeout = javaType.trialTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
