@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Sweep job definition.
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property earlyTermination Early termination policies enable canceling poor-performing runs before they complete
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property inputs Mapping of input data bindings used in the job.
 * @property isArchived Is the asset archived?
 * @property jobType Enum to determine the type of job.
 * Expected value is 'Sweep'.
 * @property limits Sweep Job limit.
 * @property objective [Required] Optimization objective.
 * @property outputs Mapping of output data bindings used in the job.
 * @property properties The asset property dictionary.
 * @property samplingAlgorithm [Required] The hyperparameter sampling algorithm
 * @property searchSpace [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property status Status of the job.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 * @property trial [Required] Trial component definition.
 */
public data class SweepJobResponse(
    public val componentId: String? = null,
    public val computeId: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val earlyTermination: Any? = null,
    public val experimentName: String? = null,
    public val identity: Any? = null,
    public val inputs: Map<String, Any>? = null,
    public val isArchived: Boolean? = null,
    public val jobType: String,
    public val limits: SweepJobLimitsResponse? = null,
    public val objective: ObjectiveResponse,
    public val outputs: Map<String, Any>? = null,
    public val properties: Map<String, String>? = null,
    public val samplingAlgorithm: Any,
    public val searchSpace: Any,
    public val services: Map<String, JobServiceResponse>? = null,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val trial: TrialComponentResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SweepJobResponse): SweepJobResponse = SweepJobResponse(
            componentId = javaType.componentId().map({ args0 -> args0 }).orElse(null),
            computeId = javaType.computeId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            earlyTermination = javaType.earlyTermination().map({ args0 -> args0 }).orElse(null),
            experimentName = javaType.experimentName().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            inputs = javaType.inputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            jobType = javaType.jobType(),
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SweepJobLimitsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            objective = javaType.objective().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ObjectiveResponse.Companion.toKotlin(args0)
            }),
            outputs = javaType.outputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            samplingAlgorithm = javaType.samplingAlgorithm(),
            searchSpace = javaType.searchSpace(),
            services = javaType.services().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobServiceResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trial = javaType.trial().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.TrialComponentResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
