@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acrAccountName Name of the ACR account
 * @property acrAccountSku SKU of the ACR account
 * @property armResourceId This is populated once the ACR account is created.
 */
public data class SystemCreatedAcrAccountResponse(
    public val acrAccountName: String? = null,
    public val acrAccountSku: String? = null,
    public val armResourceId: ArmResourceIdResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SystemCreatedAcrAccountResponse): SystemCreatedAcrAccountResponse = SystemCreatedAcrAccountResponse(
            acrAccountName = javaType.acrAccountName().map({ args0 -> args0 }).orElse(null),
            acrAccountSku = javaType.acrAccountSku().map({ args0 -> args0 }).orElse(null),
            armResourceId = javaType.armResourceId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ArmResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
