@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maxInstances The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
 * @property minInstances The minimum number of instances to always be present.
 * @property pollingInterval The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
 * @property scaleType
 * Expected value is 'TargetUtilization'.
 * @property targetUtilizationPercentage Target CPU usage for the autoscaler.
 */
public data class TargetUtilizationScaleSettingsResponse(
    public val maxInstances: Int? = null,
    public val minInstances: Int? = null,
    public val pollingInterval: String? = null,
    public val scaleType: String,
    public val targetUtilizationPercentage: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.TargetUtilizationScaleSettingsResponse): TargetUtilizationScaleSettingsResponse = TargetUtilizationScaleSettingsResponse(
            maxInstances = javaType.maxInstances().map({ args0 -> args0 }).orElse(null),
            minInstances = javaType.minInstances().map({ args0 -> args0 }).orElse(null),
            pollingInterval = javaType.pollingInterval().map({ args0 -> args0 }).orElse(null),
            scaleType = javaType.scaleType(),
            targetUtilizationPercentage = javaType.targetUtilizationPercentage().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
