@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * TensorFlow distribution configuration.
 * @property distributionType Enum to determine the job distribution type.
 * Expected value is 'TensorFlow'.
 * @property parameterServerCount Number of parameter server tasks.
 * @property workerCount Number of workers. If not specified, will default to the instance count.
 */
public data class TensorFlowResponse(
    public val distributionType: String,
    public val parameterServerCount: Int? = null,
    public val workerCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.TensorFlowResponse): TensorFlowResponse = TensorFlowResponse(
            distributionType = javaType.distributionType(),
            parameterServerCount = javaType.parameterServerCount().map({ args0 -> args0 }).orElse(null),
            workerCount = javaType.workerCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
