@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Text Classification task in AutoML NLP vertical.
 * NLP - Natural Language Processing.
 * @property featurizationSettings Featurization inputs needed for AutoML job.
 * @property limitSettings Execution constraints for AutoMLJob.
 * @property logVerbosity Log verbosity for the job.
 * @property primaryMetric Primary metric for Text-Classification task.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'TextClassification'.
 * @property trainingData [Required] Training data input.
 * @property validationData Validation data inputs.
 */
public data class TextClassificationResponse(
    public val featurizationSettings: NlpVerticalFeaturizationSettingsResponse? = null,
    public val limitSettings: NlpVerticalLimitSettingsResponse? = null,
    public val logVerbosity: String? = null,
    public val primaryMetric: String? = null,
    public val targetColumnName: String? = null,
    public val taskType: String,
    public val trainingData: MLTableJobInputResponse,
    public val validationData: MLTableJobInputResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.TextClassificationResponse): TextClassificationResponse = TextClassificationResponse(
            featurizationSettings = javaType.featurizationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NlpVerticalFeaturizationSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            limitSettings = javaType.limitSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NlpVerticalLimitSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logVerbosity = javaType.logVerbosity().map({ args0 -> args0 }).orElse(null),
            primaryMetric = javaType.primaryMetric().map({ args0 -> args0 }).orElse(null),
            targetColumnName = javaType.targetColumnName().map({ args0 -> args0 }).orElse(null),
            taskType = javaType.taskType(),
            trainingData = javaType.trainingData().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLTableJobInputResponse.Companion.toKotlin(args0)
            }),
            validationData = javaType.validationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLTableJobInputResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
