@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property count
 * @property dynamicThrottlingEnabled
 * @property key
 * @property matchPatterns
 * @property minCount
 * @property renewalPeriod
 */
public data class ThrottlingRuleResponse(
    public val count: Double? = null,
    public val dynamicThrottlingEnabled: Boolean? = null,
    public val key: String? = null,
    public val matchPatterns: List<RequestMatchPatternResponse>? = null,
    public val minCount: Double? = null,
    public val renewalPeriod: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ThrottlingRuleResponse): ThrottlingRuleResponse = ThrottlingRuleResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            dynamicThrottlingEnabled = javaType.dynamicThrottlingEnabled().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            matchPatterns = javaType.matchPatterns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RequestMatchPatternResponse.Companion.toKotlin(args0)
                })
            }),
            minCount = javaType.minCount().map({ args0 -> args0 }).orElse(null),
            renewalPeriod = javaType.renewalPeriod().map({ args0 -> args0 }).orElse(null),
        )
    }
}
