@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Trial component definition.
 * @property codeId ARM resource ID of the code asset.
 * @property command [Required] The command to execute on startup of the job. eg. "python train.py"
 * @property distribution Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
 * @property environmentId [Required] The ARM resource ID of the Environment specification for the job.
 * @property environmentVariables Environment variables included in the job.
 * @property resources Compute Resource configuration for the job.
 */
public data class TrialComponentResponse(
    public val codeId: String? = null,
    public val command: String,
    public val distribution: Any? = null,
    public val environmentId: String,
    public val environmentVariables: Map<String, String>? = null,
    public val resources: JobResourceConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.TrialComponentResponse): TrialComponentResponse = TrialComponentResponse(
            codeId = javaType.codeId().map({ args0 -> args0 }).orElse(null),
            command = javaType.command(),
            distribution = javaType.distribution().map({ args0 -> args0 }).orElse(null),
            environmentId = javaType.environmentId(),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobResourceConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
