@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
 * @property delayEvaluation Number of intervals by which to delay the first evaluation.
 * @property evaluationInterval Interval (number of runs) between policy evaluations.
 * @property policyType
 * Expected value is 'TruncationSelection'.
 * @property truncationPercentage The percentage of runs to cancel at each evaluation interval.
 */
public data class TruncationSelectionPolicyResponse(
    public val delayEvaluation: Int? = null,
    public val evaluationInterval: Int? = null,
    public val policyType: String,
    public val truncationPercentage: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.TruncationSelectionPolicyResponse): TruncationSelectionPolicyResponse = TruncationSelectionPolicyResponse(
            delayEvaluation = javaType.delayEvaluation().map({ args0 -> args0 }).orElse(null),
            evaluationInterval = javaType.evaluationInterval().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType(),
            truncationPercentage = javaType.truncationPercentage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
