@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * uri-folder data version entity
 * @property dataType Enum to determine the type of data.
 * Expected value is 'uri_folder'.
 * @property dataUri [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
 * @property description The asset description text.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class UriFolderDataVersionResponse(
    public val dataType: String,
    public val dataUri: String,
    public val description: String? = null,
    public val isAnonymous: Boolean? = null,
    public val isArchived: Boolean? = null,
    public val properties: Map<String, String>? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.UriFolderDataVersionResponse): UriFolderDataVersionResponse = UriFolderDataVersionResponse(
            dataType = javaType.dataType(),
            dataUri = javaType.dataUri(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isAnonymous = javaType.isAnonymous().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
