@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description for the output.
 * @property jobOutputType Enum to determine the Job Output Type.
 * Expected value is 'uri_folder'.
 * @property mode Output Asset Delivery Mode.
 * @property uri Output Asset URI.
 */
public data class UriFolderJobOutputResponse(
    public val description: String? = null,
    public val jobOutputType: String,
    public val mode: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.UriFolderJobOutputResponse): UriFolderJobOutputResponse = UriFolderJobOutputResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            jobOutputType = javaType.jobOutputType(),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
