@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings for user account that gets created on each on the nodes of a compute.
 * @property adminUserName Name of the administrator user account which can be used to SSH to nodes.
 * @property adminUserPassword Password of the administrator user account.
 * @property adminUserSshPublicKey SSH public key of the administrator user account.
 */
public data class UserAccountCredentialsResponse(
    public val adminUserName: String,
    public val adminUserPassword: String? = null,
    public val adminUserSshPublicKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.UserAccountCredentialsResponse): UserAccountCredentialsResponse = UserAccountCredentialsResponse(
            adminUserName = javaType.adminUserName(),
            adminUserPassword = javaType.adminUserPassword().map({ args0 -> args0 }).orElse(null),
            adminUserSshPublicKey = javaType.adminUserSshPublicKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
