@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User assigned identity properties
 * @property clientId The client ID of the assigned identity.
 * @property principalId The principal ID of the assigned identity.
 * @property tenantId The tenant ID of the user assigned identity.
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.UserAssignedIdentityResponse): UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
