@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address Public IP address of the virtual machine.
 * @property administratorAccount Admin credentials for virtual machine
 * @property isNotebookInstanceCompute Indicates whether this compute will be used for running notebooks.
 * @property notebookServerPort Notebook server port open for ssh connections.
 * @property sshPort Port open for ssh connections.
 * @property virtualMachineSize Virtual Machine size
 */
public data class VirtualMachineSchemaResponseProperties(
    public val address: String? = null,
    public val administratorAccount: VirtualMachineSshCredentialsResponse? = null,
    public val isNotebookInstanceCompute: Boolean? = null,
    public val notebookServerPort: Int? = null,
    public val sshPort: Int? = null,
    public val virtualMachineSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.VirtualMachineSchemaResponseProperties): VirtualMachineSchemaResponseProperties = VirtualMachineSchemaResponseProperties(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            administratorAccount = javaType.administratorAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.VirtualMachineSshCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isNotebookInstanceCompute = javaType.isNotebookInstanceCompute().map({ args0 ->
                args0
            }).orElse(null),
            notebookServerPort = javaType.notebookServerPort().map({ args0 -> args0 }).orElse(null),
            sshPort = javaType.sshPort().map({ args0 -> args0 }).orElse(null),
            virtualMachineSize = javaType.virtualMachineSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
