@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the properties of a VM size.
 * @property estimatedVMPrices The estimated price information for using a VM.
 * @property family The family name of the virtual machine size.
 * @property gpus The number of gPUs supported by the virtual machine size.
 * @property lowPriorityCapable Specifies if the virtual machine size supports low priority VMs.
 * @property maxResourceVolumeMB The resource volume size, in MB, allowed by the virtual machine size.
 * @property memoryGB The amount of memory, in GB, supported by the virtual machine size.
 * @property name The name of the virtual machine size.
 * @property osVhdSizeMB The OS VHD disk size, in MB, allowed by the virtual machine size.
 * @property premiumIO Specifies if the virtual machine size supports premium IO.
 * @property supportedComputeTypes Specifies the compute types supported by the virtual machine size.
 * @property vCPUs The number of vCPUs supported by the virtual machine size.
 */
public data class VirtualMachineSizeResponse(
    public val estimatedVMPrices: EstimatedVMPricesResponse? = null,
    public val family: String,
    public val gpus: Int,
    public val lowPriorityCapable: Boolean,
    public val maxResourceVolumeMB: Int,
    public val memoryGB: Double,
    public val name: String,
    public val osVhdSizeMB: Int,
    public val premiumIO: Boolean,
    public val supportedComputeTypes: List<String>? = null,
    public val vCPUs: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.VirtualMachineSizeResponse): VirtualMachineSizeResponse = VirtualMachineSizeResponse(
            estimatedVMPrices = javaType.estimatedVMPrices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EstimatedVMPricesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            family = javaType.family(),
            gpus = javaType.gpus(),
            lowPriorityCapable = javaType.lowPriorityCapable(),
            maxResourceVolumeMB = javaType.maxResourceVolumeMB(),
            memoryGB = javaType.memoryGB(),
            name = javaType.name(),
            osVhdSizeMB = javaType.osVhdSizeMB(),
            premiumIO = javaType.premiumIO(),
            supportedComputeTypes = javaType.supportedComputeTypes().map({ args0 -> args0 }),
            vCPUs = javaType.vCPUs(),
        )
    }
}
